Attribute VB_Name = "Util"
Option Explicit

Public Const utilGeneralError = 666 'vbObjectError + 1 DFL KB#27
Public Const utilValidationError = 667 'vbObjectError + 2

Public Enum AlertBoxButtons

  abbNone = 0
  abbOk = 1
  abbOkCancel = 17
  abbYes = 4
  abbNo = 8
  abbYesNo = 12
  abbYesNoCancel = 28
  abbretry = 2
  abbCancel = 16
  abbRetryCancel = 18
  abbAll = 31
  abbCustom1 = 32
  abbCustom2 = 64
  abbCustom3 = 128

End Enum

Public Enum AlertBoxIcons
  abiAPPLICATION = 32512&
  abiCritical = 32513& ' critical
  abiQuestion = 32514&
  abiExclamation = 32515&
  abiInformation = 32516& ' information
End Enum

Public Enum DBTypesT
  dbPing
  dbDevelopment
  dbParameters
End Enum

Public Enum InRangeInterval
  iriLowerExclusive = 1
  iriUpperExclusive = 2
End Enum
 
Public Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)

' Returns size of things in pixels
Public Declare Function GetSystemMetrics Lib "USER32" (ByVal nIndex As Long) As Long
Private Const SM_CYCAPTION = 4
Private Const SM_CYMENU = 15
Private Const SM_CYBORDER = 6
Private Const SM_CXBORDER = 5
Private Const SM_CYFRAME = 33
Private Const SM_CXFRAME = 32

Public Const VERY_BIG_NUMBER = 10000

Public Type SYSTEMTIME
        wYear As Integer
        wMonth As Integer
        wDayOfWeek As Integer
        wDay As Integer
        wHour As Integer
        wMinute As Integer
        wSecond As Integer
        wMilliseconds As Integer
End Type

Public Declare Sub GetSystemTime Lib "kernel32" (lpSystemTime As SYSTEMTIME)


Public Function CeilDivide(ByVal dividend As Long, ByVal divisor As Long) As Long

  Dim result As Long
  
  result = dividend \ divisor
  If dividend Mod divisor <> 0 And result > 0 Then result = result + 1
  
  CeilDivide = result

End Function

Public Function CharToEscape(ByVal C As String, _
                              Optional ByVal onlyIfNonPrintable As Boolean = True) As String
                              
  Dim printable As Boolean
  C = Left(C, 1)
  printable = (C >= " " And C <= "~")
  If printable And onlyIfNonPrintable Then
    CharToEscape = C
  ElseIf Asc(C) < 16 Then
    CharToEscape = "\0x" & Hex(Asc(C))
  Else
    CharToEscape = "\x" & Hex(Asc(C))
  End If
  
End Function

Public Function ColorIsDark(ByVal color As Long) As Boolean

  ColorIsDark = GetBlue(color) < 192 Or GetRed(color) < 192 Or GetGreen(color) < 192

End Function

Public Function CopyCutTextPossible() As Boolean

  If TypeOf Screen.ActiveControl Is TextBox Then
    CopyCutTextPossible = True
  ElseIf TypeOf Screen.ActiveControl Is ComboBox Then
    CopyCutTextPossible = True
  ElseIf TypeOf Screen.ActiveControl Is ListBox Then
    CopyCutTextPossible = True
  Else
    CopyCutTextPossible = False
  End If

End Function

Public Sub CopyToClipboard()

  Clipboard.Clear
  If TypeOf Screen.ActiveControl Is TextBox Then
    Clipboard.SetText Screen.ActiveControl.SelText
  ElseIf TypeOf Screen.ActiveControl Is ComboBox Then
    Clipboard.SetText Screen.ActiveControl.text
  ElseIf TypeOf Screen.ActiveControl Is PictureBox Then
    Clipboard.SetData Screen.ActiveControl.picture
  ElseIf TypeOf Screen.ActiveControl Is ListBox Then
    Clipboard.SetText Screen.ActiveControl.text
  Else
    ' Doesn't make sense
  End If
End Sub

Public Sub CutToClipboard()

  CopyToClipboard
  If TypeOf Screen.ActiveControl Is TextBox Then
    Screen.ActiveControl.SelText = ""
  ElseIf TypeOf Screen.ActiveControl Is ComboBox Then
    Screen.ActiveControl.text = ""
  ElseIf TypeOf Screen.ActiveControl Is PictureBox Then
    Screen.ActiveControl.picture = LoadPicture()
  ElseIf TypeOf Screen.ActiveControl Is ListBox Then
    Screen.ActiveControl.text = ""
  Else
    ' Doesn't make sense
  End If
End Sub

Public Function ErrorBox(Optional ByVal bodyPrefix As String = "", _
                     Optional ByVal boxCaption As String = "Error", _
                    Optional ByVal category As Integer = vbExclamation) As Integer
  
  Dim reply As Integer
  Dim prompt As String
  
  If Err.number <> 0 Then MyStoredError.Store
  
  On Error GoTo oops:
  Err.Clear

  prompt = IIf(bodyPrefix = "", "", bodyPrefix & Chr(10) & vbCrLf) & "Error #" & _
                              MyStoredError.number & ": " & MyStoredError.description

  reply = MsgBox(prompt, category, boxCaption)
  
  ErrorBox = reply
  
  Exit Function

oops:
  Debug.Assert (False)
  
End Function

Public Sub StoreError()
  
  Debug.Assert (False)
  MyStoredError.Store
  
End Sub

Public Function FileExists(ByVal filename As String, _
                           Optional ByVal writable As Boolean = False) As Boolean
                            
                            
  Dim fs As FileSystemObject
  Dim ok As Boolean
  
  Set fs = CreateObject("scripting.filesystemobject")
  ok = fs.FileExists(filename)
  If ok And writable Then
    ok = (fs.GetFile(filename).Attributes And ReadOnly) = 0
  End If
  
  FileExists = ok
    
End Function
                 
Public Function FormatSingle(ByVal X As Single) As String

  If X = 0 Then
    FormatSingle = "0"
  ElseIf Abs(X) < 0.001 Or Abs(X) > 99999 Then
    FormatSingle = Format(X, "0.0e-##")
  ElseIf Abs(X) <= 99999 And Abs(X) > 999 Then
    FormatSingle = Format(X, "##,##0")
  Else
    FormatSingle = Format(X, "##0.###")
  End If

End Function

Public Function GenerateUniqueID(Optional ByVal nRandomDigits As Integer = 6, _
                                 Optional ByVal separator As String = ":", _
                                 Optional ByVal useRandomPart As Boolean = True) As String
  
  Dim randomPart As String
  Dim timePart As String
  
  timePart = Format(Now, "yymmddhhNnSs")
  GenerateUniqueID = timePart
  If useRandomPart Then
    If nRandomDigits > 10 Then nRandomDigits = 10
    randomPart = Format(CLng(Rnd() * 10 ^ nRandomDigits), Left("000000000000000", nRandomDigits))
    GenerateUniqueID = timePart & separator & randomPart
  End If

End Function

Public Function GetBestMatchD(ByVal value As Double, ParamArray matchList()) As Double

  Dim d As Double
  Dim distance As Double
  Dim i As Long
  Dim matchIndex As Long
  distance = 1E+20
  
  Debug.Assert (UBound(matchList) >= LBound(matchList))
  
  For i = LBound(matchList) To UBound(matchList)
    d = Abs(value - matchList(i))
    If d < distance Then
      distance = d
      matchIndex = i
    End If
  Next i
  
  GetBestMatchD = matchList(matchIndex)

End Function

Public Function GetBlue(ByVal C As Long) As Integer

  GetBlue = ((C \ 65536) And &HFF)

End Function

Public Function GetFormsReservedHeight(Optional ByVal hasMenuBar As Boolean = True, _
                                       Optional ByVal hasCaption As Boolean = True) As Double

  ' Returns the height of the menu and caption bars, etc., of forms.
  ' Result is in twips.

  GetFormsReservedHeight = _
    (IIf(hasCaption, GetSystemMetrics(SM_CYCAPTION), 0) + IIf(hasMenuBar, GetSystemMetrics(SM_CYMENU), 0) + _
     (GetSystemMetrics(SM_CYBORDER) + GetSystemMetrics(SM_CYFRAME)) * 2) * Screen.TwipsPerPixelY

End Function

Public Function GetFormsReservedWidth() As Double

  ' Returns the width of the borders, etc., of forms.
  ' Result is in twips.

  GetFormsReservedWidth = _
    ((GetSystemMetrics(SM_CXBORDER) + GetSystemMetrics(SM_CXFRAME)) * 2) * Screen.TwipsPerPixelY

End Function

Public Function GetGreen(ByVal C As Long) As Integer

  GetGreen = ((C \ 256) And &HFF)

End Function

Public Function GetRed(ByVal C As Long) As Integer

  GetRed = (C And &HFF)

End Function

Public Function GetTextAsDouble(Control As Variant, Optional prompt As String) As Double

  Dim text As String
  text = Control.text
  ThrowIfNotNumeric text, Control, prompt
  GetTextAsDouble = text

End Function

Public Function GetTextAsLong(Control As Variant, Optional prompt As String) As Long

  Dim text As String
  text = Control.text
  ThrowIfNotNumeric text, Control, prompt
  GetTextAsLong = text

End Function

Public Function InRange(ByVal lower As Long, ByVal value As Long, _
            ByVal upper As Long, Optional ByVal flags As InRangeInterval = 0) As Boolean
                        
  '  Returns true if the value is in the specified range.
  '  The flags variable allows the range to have exclusive endpoints
  '  (i.e., the value may not be equal to an endpoint).  All four combinations
  '  of endpoint exclusivity are possible; the default is that both are
  '  inclusive.
  
  If (flags And iriLowerExclusive) = 0 Then
    InRange = (value >= lower)
  Else
    InRange = (value > lower)
  End If
  
  If Not InRange Then Exit Function
  
  If (flags And iriUpperExclusive) = 0 Then
    InRange = (value <= upper)
  Else
    InRange = (value < upper)
  End If
  
End Function

Public Function inSet(ByVal value, ParamArray elements()) As Boolean

  '  Returns true if the value is in the set specified in
  '  parameters 2 ...

  Dim i As Long

  inSet = False
  If VarType(value) <> VarType(elements(0)) Then
    If IsNumeric(value) Then value = CLng(value)
  End If
    
  For i = 0 To UBound(elements)
    If value = elements(i) Then
      inSet = True
      Exit For
    End If
  Next i

End Function

Public Function LatLonDoubleToString(ByVal LatOrLon As Double, _
                           ByVal isLat As Boolean) As String
 
  Dim degrees As Long
  Dim direction As String
  Dim minutes As Double
 
  If LatOrLon < 0 Then
    If isLat Then
      direction = "S"
    Else
      direction = "W"
    End If
  Else
    If isLat Then
      direction = "N"
    Else
      direction = "E"
    End If
  End If
 
  LatOrLon = Abs(LatOrLon)
  degrees = Fix(LatOrLon)
  minutes = (LatOrLon - degrees) * 60
 
  LatLonDoubleToString = CStr(degrees) & " " & Format(minutes, "00.000") & _
                         "' " & direction
End Function

Public Function limitD(ByVal lower As Double, ByVal value As Double, _
                       ByVal upper As Double) As Double
                       
  ' Limits value to a range
                        
  Debug.Assert (lower <= upper)
  If value < lower Then
    limitD = lower
  ElseIf value > upper Then
    limitD = upper
  Else
    limitD = value
  End If
                        
End Function

Public Function limitL(ByVal lower As Long, ByVal value As Long, _
                       ByVal upper As Long) As Long
                       
  ' Limits value to a range
                        
  Debug.Assert (lower <= upper)
  If value < lower Then
    limitL = lower
  ElseIf value > upper Then
    limitL = upper
  Else
    limitL = value
  End If
                        
End Function

Public Function log10(ByVal X As Double) As Double

  log10 = Log(X) * 0.434294481903 ' divide by log(10)

End Function

Public Function maxd(ByVal X As Double, ByVal Y As Double) As Double

  If X > Y Then
    maxd = X
  Else
    maxd = Y
  End If

End Function

Public Function maxl(ByVal X As Long, ByVal Y As Long) As Long

  If X > Y Then
    maxl = X
  Else
    maxl = Y
  End If

End Function

Public Function mind(ByVal X As Double, ByVal Y As Double) As Double

  If X < Y Then
    mind = X
  Else
    mind = Y
  End If

End Function

Public Function minl(ByVal X As Long, ByVal Y As Long) As Long

  If X < Y Then
    minl = X
  Else
    minl = Y
  End If

End Function

Public Function Modulus(ByVal arg As Long, ByVal base As Long) As Long

  arg = arg Mod base
  If arg < 0 Then arg = arg + base
  Modulus = arg

End Function

Public Function NextPowerOf2(ByVal X As Long) As Long

  Dim n As Long
  
  If X > 0 Then
    X = X - 1
    n = 1
    Do While X > 0
      X = X \ 2
      n = 2 * n
    Loop
    NextPowerOf2 = n
  Else
    NextPowerOf2 = 1
  End If

End Function

Public Sub PasteFromClipboard()

  If TypeOf Screen.ActiveControl Is TextBox Then
    Screen.ActiveControl.SelText = Clipboard.GetText()
  ElseIf TypeOf Screen.ActiveControl Is ComboBox Then
    Screen.ActiveControl.text = Clipboard.GetText()
  ElseIf TypeOf Screen.ActiveControl Is PictureBox Then
    Screen.ActiveControl.picture = Clipboard.GetData()
  ElseIf TypeOf Screen.ActiveControl Is ListBox Then
    Screen.ActiveControl.text = Clipboard.GetText()
  Else
    ' Doesn't make sense
  End If
  
End Sub

Public Function PasteTextPossible() As Boolean

  Dim ok As Boolean

  If TypeOf Screen.ActiveControl Is TextBox Then
    ok = True
  ElseIf TypeOf Screen.ActiveControl Is ComboBox Then
    ok = True
  ElseIf TypeOf Screen.ActiveControl Is ListBox Then
    ok = True
  Else
    ok = False
  End If
  
  PasteTextPossible = ok And Clipboard.GetFormat(vbCFText)

End Function

Public Function RangeToSample(ByVal rangeM As Single, ByVal soundSpeedMPS As Single, _
                               ByVal samplingPeriodNS As Long) As Long
                               
                               
  RangeToSample = rangeM * 2 / CDbl(soundSpeedMPS) / CDbl((samplingPeriodNS * 0.000000001))
                               
End Function

Public Function SampleToRange(ByVal sample As Long, ByVal soundSpeedMPS As Single, _
                              ByVal samplingPeriodNS As Long)
                               
  SampleToRange = CDbl(sample) / 2 * soundSpeedMPS * (samplingPeriodNS * 0.000000001)
                               
End Function

Public Sub SelectComboBoxElement(box As ComboBox, ByVal value As String, _
                          Optional ByVal compareItemData As Boolean = False)

  Dim i As Integer

  If compareItemData Then
  
    For i = 0 To box.ListCount - 1
      If box.ItemData(i) = value Then
        box.ListIndex = i
        Exit For
      End If
    Next i
  
  Else
  
    For i = 0 To box.ListCount - 1
      If box.List(i) = value Then
        box.ListIndex = i
        Exit For
      End If
    Next i
  End If

End Sub

Public Function SystemTimeDifferenceMs(laterTime As SYSTEMTIME, earlierTime As SYSTEMTIME) As Long

  ' Returns the difference between two system times in milliseconds
  
  Dim early As Date
  Dim later As Date
  Dim difference As Double
  Dim delta As Long
  
  With laterTime
    later = DateSerial(.wYear, .wMonth, .wDay)
    later = later + TimeSerial(.wHour, .wMinute, .wSecond)
  End With
  With earlierTime
    early = DateSerial(.wYear, .wMonth, .wDay)
    early = early + TimeSerial(.wHour, .wMinute, .wSecond)
  End With
  
  difference = later - early
  
  delta = difference * 24 * 3600 * 1000 ' convert to ms
  delta = delta + laterTime.wMilliseconds - earlierTime.wMilliseconds

  SystemTimeDifferenceMs = delta

End Function

Public Function SystemTimeToDate(theTime As SYSTEMTIME) As Date

  ' Returns the difference between two system times in milliseconds
  
  Dim early As Date
  
  With theTime
    early = DateSerial(.wYear, .wMonth, .wDay)
    early = early + TimeSerial(.wHour, .wMinute, .wSecond)
  End With
  
  SystemTimeToDate = early

End Function

Public Sub Rethrow(ByVal tag As String)

  '  Tacks on a tag to the front of the error description and throws
  '  it again.
  
  Err.Raise Err.number, Err.Source, tag & vbCrLf & Err.description, _
            Err.helpFile, Err.HelpContext

End Sub

Public Sub RethrowStoredError()

  With MyStoredError
    .Raise .number, .Source, .description, .helpFile, .HelpContext
  End With

End Sub

Public Function StringToEscape(ByVal s As String, _
                                Optional ByVal onlyIfNonPrintable As Boolean = True) As String

  Dim result As String
  result = ""
  
  Dim i As Long
  For i = 1 To Len(s)
    result = result & CharToEscape(Mid(s, i, 1), onlyIfNonPrintable)
  Next i
  
  StringToEscape = result

End Function

Public Function SqlStrip(ByVal text As String) As String
  
  SqlStrip = Replace(text, "'", "?")

End Function

Public Function SystemTimeToString(t As SYSTEMTIME) As String

  Dim result As String
  
  With t
    result = Format(.wMonth, "##")
    result = result & "/" & Format(.wDay, "##")
    result = result & "/" & Format(.wYear, "0000")
    result = result & " " & Format(.wHour, "00")
    result = result & ":" & Format(.wMinute, "00")
    result = result & ":" & Format(.wSecond, "00")
    result = result & "." & Format(.wMilliseconds, "000")
  End With
  
  SystemTimeToString = result

End Function

Public Sub TextboxColorize(box As TextBox, _
                           Optional ByVal forecolor = vbButtonText, _
                           Optional ByVal backcolor = vbWindowBackground)
                           
  box.forecolor = forecolor
  box.backcolor = backcolor
                           
End Sub

Public Sub TextboxSelectAll(box As TextBox, _
                            Optional ByVal forecolor As Variant, _
                            Optional ByVal backcolor As Variant)
                            
' Selects all the text in a text box.  Useful when called inside a
' GotFocus handler

  If Not IsMissing(forecolor) Then box.forecolor = forecolor
  If Not IsMissing(backcolor) Then box.backcolor = backcolor
  
  box.SelStart = 0
  box.SelLength = Len(box.text)

End Sub

Public Sub Throw(ByVal code As Long, Optional ByVal description As String = "")

  If description <> "" Then
    Err.Raise code, , description
  Else
    Err.Raise code
  End If

End Sub

Public Sub ThrowIfNotNumeric(ByVal value As String, Optional Control As Variant, _
                                                          Optional prompt As String)
  
  If (Not IsNumeric(value)) Then
    If (IsMissing(prompt)) Then
      prompt = "Value is"
    End If
    prompt = prompt & " invalid number."
    MsgBox prompt, vbExclamation
    If (Not IsMissing(Control)) Then
      Control.SetFocus
    End If
    Throw utilValidationError
  End If
  
End Sub

Public Function ToHex(ByVal arg As Long, Optional ByVal minDigits As Integer = 0) As String

  ToHex = Hex(arg)
  If Len(ToHex) < minDigits Then ToHex = Left("000000000000", minDigits - Len(ToHex)) & ToHex

End Function

Public Function ToRoundNumber(ByVal X As Single, Optional ByVal interval As Long = 10, _
                              Optional ByVal up As Boolean = True)
                      
  Dim base As Single
  
  base = Int(X / interval) * interval
  If base <> X Then
    If up Then
      base = base + interval
    Else
      base = base - interval
    End If
  End If
  
  ToRoundNumber = base

End Function

Public Function ValidateFloatString( _
  tbString As String, _
  Optional ByVal minValue As Variant, _
  Optional ByVal maxValue As Variant, _
  Optional ByVal defaultValue As Variant, _
  Optional valueName As String = "Value", _
  Optional theValue As Single, _
  Optional throwOnError As Boolean = False) As Boolean
  
  ' Check to see if the text is a valid floating point number.
  ' If the text only contains whitespace, then use the defaultValue
  ' if provided.
  
  On Error GoTo oops
  
  Dim X As Double
  
  If Trim(tbString) = "" And Not IsMissing(defaultValue) Then
    X = defaultValue
    tbString = X
  Else
    ThrowIfNotNumeric tbString, , valueName
    X = tbString
  End If
  
  '   Check to see if the value is greater than the required min
  
  If Not IsMissing(minValue) Then
    If X < minValue Then
      MsgBox valueName & " is too small.", vbExclamation
      ValidateFloatString = False
      Exit Function
    End If
  End If
  
  '   Check to see if the value is less than the require max
  
  If Not IsMissing(maxValue) Then
    If X > maxValue Then
      MsgBox valueName & " is too big.", vbExclamation
      ValidateFloatString = False
      Exit Function
    End If
  End If
  
  ValidateFloatString = True
  If Not IsMissing(theValue) Then theValue = X
  Exit Function
  
oops:
  ValidateFloatString = False
  On Error GoTo 0
  If throwOnError Then Throw utilValidationError
  
End Function


Public Function ValidateFloatTextBox( _
  tb As TextBox, _
  Optional ByVal minValue As Variant, _
  Optional ByVal maxValue As Variant, _
  Optional ByVal defaultValue As Variant, _
  Optional valueName As String = "Value", _
  Optional theValue As Single, _
  Optional throwOnError As Boolean = False) As Boolean
  
  ' Check to see if the text is a valid floating point number.
  ' If the text only contains whitespace, then use the defaultValue
  ' if provided.
  
  On Error GoTo oops
  
  Dim X As Double
  
  If Trim(tb.text) = "" And Not IsMissing(defaultValue) Then
    X = defaultValue
    tb.text = X
  Else
    ThrowIfNotNumeric tb.text, tb, valueName
    X = tb.text
  End If
  
  '   Check to see if the value is greater than the required min
  
  If Not IsMissing(minValue) Then
    If X < minValue Then
      MsgBox valueName & " is too small.", vbExclamation
      Throw utilValidationError
    End If
  End If
  
  '   Check to see if the value is less than the require max
  
  If Not IsMissing(maxValue) Then
    If X > maxValue Then
      MsgBox valueName & " is too big.", vbExclamation
      Throw utilValidationError
    End If
  End If
  
  tb.forecolor = vbBlack
  ValidateFloatTextBox = True
  If Not IsMissing(theValue) Then theValue = X
  Exit Function
  
oops:
  TextboxSelectAll tb, vbBlack, vbYellow
  tb.SetFocus
  ValidateFloatTextBox = False
  On Error GoTo 0
  If throwOnError Then Throw utilValidationError
  
End Function

Public Function IsWholeNumber(value As Variant) As Variant
  
  On Error GoTo oops:
  
  IsWholeNumber = False
  Dim testDB As Double
  Dim testLG As Long
  
  Select Case TypeName(value)
    Case "Integer", "Long"
      IsWholeNumber = True
      
    Case "String"
      If IsNumeric(value) Then
        testDB = Val(value)
        testLG = CLng(Val(value))
        IsWholeNumber = (testDB = testLG)
      End If
      
    Case Else
        IsWholeNumber = False
  
  End Select
  
  Exit Function
  
oops:
  StoreError
  IsWholeNumber = False

End Function

Public Function ValidateLongString( _
  tbString As String, _
  Optional ByVal minValue As Variant, _
  Optional ByVal maxValue As Variant, _
  Optional ByVal defaultValue As Variant, _
  Optional valueName As String = "Value", _
  Optional theValue As Long, _
  Optional throwOnError As Boolean = False) As Boolean

  ' Check to see if the text is a valid floating point number.
  ' If the text only contains whitespace, then use the defaultValue
  ' if provided.
  
  On Error GoTo oops
  
  Dim X As Long
  
  If Trim(tbString) = "" And Not IsMissing(defaultValue) Then
    X = defaultValue
  Else
    ThrowIfNotNumeric tbString, valueName
    If Not IsWholeNumber(tbString) Then
      MsgBox valueName & " needs to be a whole number.", vbExclamation
      ValidateLongString = False
      Exit Function
    End If
    X = tbString
  End If
  
  '   Check to see if the value is greater than the required min
  
  If Not IsMissing(minValue) Then
    If X < minValue Then
      MsgBox valueName & " is too small.", vbExclamation
     ' Throw utilValidationError
      ValidateLongString = False
      Exit Function
    End If
  End If
  
  '   Check to see if the value is less than the require max
  
  If Not IsMissing(maxValue) Then
    If X > maxValue Then
      MsgBox valueName & " is too big.", vbExclamation
     ' Throw utilValidationError
      ValidateLongString = False
      Exit Function
    End If
  End If
  
  ValidateLongString = True
  If Not IsMissing(theValue) Then theValue = X
  Exit Function
  
oops:
  ValidateLongString = False
  On Error GoTo 0
  If throwOnError Then Throw utilValidationError

End Function
  
Public Function ValidateLongTextBox( _
  tb As TextBox, _
  Optional ByVal minValue As Variant, _
  Optional ByVal maxValue As Variant, _
  Optional ByVal defaultValue As Variant, _
  Optional valueName As String = "Value", _
  Optional theValue As Long, _
  Optional throwOnError As Boolean = False) As Boolean

  Dim X As Long

  ' Check to see if the text is a valid floating point number.
  ' If the text only contains whitespace, then use the defaultValue
  ' if provided.
  
  On Error GoTo oops
  If Trim(tb.text) = "" And Not IsMissing(defaultValue) Then
    X = defaultValue
  Else
    ThrowIfNotNumeric tb.text, tb, valueName
    X = tb.text
  End If
  
  '   Check to see if the value is greater than the required min
  
  If Not IsMissing(minValue) Then
    If X < minValue Then
      MsgBox valueName & " is too small.", vbExclamation
      Throw utilValidationError
    End If
  End If
  
  '   Check to see if the value is less than the require max
  
  If Not IsMissing(maxValue) Then
    If X > maxValue Then
      MsgBox valueName & " is too big.", vbExclamation
      Throw utilValidationError
    End If
  End If
  
  tb.forecolor = vbBlack
  tb.backcolor = vbWhite
  ValidateLongTextBox = True
  If Not IsMissing(theValue) Then theValue = X
  Exit Function
  
oops:
  TextboxSelectAll tb, vbBlack, vbYellow
  tb.SetFocus
  ValidateLongTextBox = False
  On Error GoTo 0
  If throwOnError Then Throw utilValidationError
  
End Function

Public Function GetSoftwareVersion() As String

  ' Might be useful to have the software version here...  - REB 2002.08.21
  ' this is more of a stub at the moment
  On Error GoTo oops:
  GetSoftwareVersion = "SF Tracker V20021104"
  
  Exit Function
oops:
  StoreError
  MyStoredError.Raise
  
End Function

Public Function IsBetween(value As Variant, lower As Variant, upper As Variant, _
                          Optional exclusiveLower As Boolean = False, _
                          Optional exclusiveUpper As Boolean = False, _
                          Optional exclusive As Boolean = True) As Boolean
  
  On Error GoTo oops:

  ' lower limit
  If exclusiveLower Or exclusive Then
    If value <= lower Then
      IsBetween = False
      Exit Function
    Else
      ' passed for lower
    End If
  Else
      If value < lower Then
        IsBetween = False
        Exit Function
    Else
      ' passed for lower
    End If
  End If
  
    If exclusiveUpper Or exclusive Then
    If value >= upper Then
        IsBetween = False
        Exit Function
    Else
      ' passed for lower
    End If
  Else
      If value > upper Then
        IsBetween = False
        Exit Function
    Else
      ' passed for lower
    End If
  End If
  
  IsBetween = True
  
  Exit Function
oops:
  StoreError
  MyStoredError.Raise
  
End Function

Public Function IsConfigurationID(searchingIn As String) As Boolean
  ' This function assumes that current naming convention of _
   using @#!#$ConfigurationID as the key in the db for tables containing _
   configurations.
  
  ' Returns false if the string does not look like a configuration ID
  ' tested - works
  On Error GoTo oops:
  
  Dim result As Long
  result = InStr(1, searchingIn, "ConfigurationID", vbTextCompare)
  IsConfigurationID = IIf(result = 0, False, True)
  
  Exit Function
oops:
  StoreError
  MyStoredError.Raise
  
End Function

Public Function TextFieldValid(text As String, minLength As Integer, _
                              maxLength As Integer) As Boolean
  On Error GoTo oops:
  
  TextFieldValid = IsBetween(Len(text), minLength, maxLength, exclusive:=False)
  
  Exit Function
  
oops:
  StoreError
  
End Function

  Public Function IF_MsgBox(Optional ByVal prompt As String = "", _
                          Optional ByVal buttons As VbMsgBoxStyle = vbOK, _
                          Optional ByVal title As String = "", _
                          Optional ByVal helpFile As String = "", _
                          Optional ByVal context As Long, _
                          Optional ByVal condition As Boolean, _
                          Optional default As VbMsgBoxResult = vbCancel) As Integer
  On Error GoTo oops:
  
  If condition = False Then
    IF_MsgBox = -1
    Exit Function
  End If

  IF_MsgBox = MsgBox(prompt, buttons, title, helpFile, context)
  
  Exit Function
  
oops:
  StoreError
  
End Function
